/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.google.inject.Inject;
import technology.rocketjump.undermount.assets.RoomEdgeTypeDictionary;
import technology.rocketjump.undermount.assets.WallQuadrantDictionary;
import technology.rocketjump.undermount.assets.model.RoomEdgeType;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.layout.RoomTileLayout;
import technology.rocketjump.undermount.rooms.Room;
import technology.rocketjump.undermount.sprites.TerrainSpriteCache;
import technology.rocketjump.undermount.sprites.model.QuadrantSprites;

public class RoomRenderer {
    public static final float TILE_MIDPOINT_DISTANCE = 0.5f;
    private final WallQuadrantDictionary quadrantDictionary;
    private final RoomEdgeTypeDictionary roomEdgeTypeDictionary;

    @Inject
    public RoomRenderer(WallQuadrantDictionary quadrantDictionary, RoomEdgeTypeDictionary roomEdgeTypeDictionary) {
        this.quadrantDictionary = quadrantDictionary;
        this.roomEdgeTypeDictionary = roomEdgeTypeDictionary;
    }

    public void render(MapTile mapTile, SpriteBatch spriteBatch, TerrainSpriteCache spriteCache) {
        Room room = mapTile.getRoomTile().getRoom();
        this.roomEdgeTypeDictionary.getByName(room.getRoomType().getEdgeName());
        spriteBatch.setColor(room.getRoomType().getColor());
        RoomTileLayout layout = mapTile.getRoomTile().getLayout();
        RoomEdgeType roomEdgeType = this.roomEdgeTypeDictionary.getByName(room.getRoomType().getEdgeName());
        QuadrantSprites quadrantSprites = spriteCache.getSpritesForRoomEdge(roomEdgeType, layout);
        float worldX = mapTile.getTileX();
        float worldY = mapTile.getTileY();
        if (quadrantSprites.getA() != null) {
            spriteBatch.draw(quadrantSprites.getA().getTexture(), worldX, worldY + 0.5f, 0.25f, 0.25f, 0.5f, 0.5f, quadrantSprites.getA().getScaleX(), quadrantSprites.getA().getScaleY(), 0.0f, quadrantSprites.getA().getRegionX(), quadrantSprites.getA().getRegionY(), quadrantSprites.getA().getRegionWidth() - 32, quadrantSprites.getA().getRegionHeight() - 32, false, false);
        }
        if (quadrantSprites.getB() != null) {
            spriteBatch.draw(quadrantSprites.getB().getTexture(), worldX + 0.5f, worldY + 0.5f, 0.25f, 0.25f, 0.5f, 0.5f, quadrantSprites.getB().getScaleX(), quadrantSprites.getB().getScaleY(), 0.0f, quadrantSprites.getB().getRegionX() + 32, quadrantSprites.getB().getRegionY(), quadrantSprites.getB().getRegionWidth() - 32, quadrantSprites.getB().getRegionHeight() - 32, false, false);
        }
        if (quadrantSprites.getC() != null) {
            spriteBatch.draw(quadrantSprites.getC().getTexture(), worldX, worldY, 0.25f, 0.25f, 0.5f, 0.5f, quadrantSprites.getC().getScaleX(), quadrantSprites.getC().getScaleY(), 0.0f, quadrantSprites.getC().getRegionX(), quadrantSprites.getC().getRegionY() + 32, quadrantSprites.getC().getRegionWidth() - 32, quadrantSprites.getC().getRegionHeight() - 32, false, false);
        }
        if (quadrantSprites.getD() != null) {
            spriteBatch.draw(quadrantSprites.getD().getTexture(), worldX + 0.5f, worldY, 0.25f, 0.25f, 0.5f, 0.5f, quadrantSprites.getD().getScaleX(), quadrantSprites.getD().getScaleY(), 0.0f, quadrantSprites.getD().getRegionX() + 32, quadrantSprites.getD().getRegionY() + 32, quadrantSprites.getD().getRegionWidth() - 32, quadrantSprites.getD().getRegionHeight() - 32, false, false);
        }
    }
}

